<?php
/**
 * GlobalExpress Services Page
 * Browse and order additional services
 */

session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if user is logged in
$isLoggedIn = isset($_SESSION['user_id']);
$userId = $_SESSION['user_id'] ?? null;
$userType = $_SESSION['user_type'] ?? 'individual';

// Database connection
$host = "localhost";
$db = "globalexpress_db";
$user = "huseyn_emil";
$pass = "Emilim2014!";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Get service categories
    $stmt = $pdo->prepare("
        SELECT * FROM service_categories 
        WHERE is_active = 1 
        AND (target_audience = ? OR target_audience = 'both')
        ORDER BY sort_order ASC
    ");
    $stmt->execute([$userType]);
    $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get services by category
    $servicesByCategory = [];
    foreach ($categories as $category) {
        $stmt = $pdo->prepare("
            SELECT * FROM services 
            WHERE category_id = ? 
            AND is_active = 1
            AND (target_audience = ? OR target_audience = 'both')
            ORDER BY sort_order ASC
        ");
        $stmt->execute([$category['id'], $userType]);
        $servicesByCategory[$category['id']] = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    
    // Get featured services
    $stmt = $pdo->prepare("
        SELECT * FROM services 
        WHERE is_featured = 1 
        AND is_active = 1
        AND (target_audience = ? OR target_audience = 'both')
        ORDER BY sort_order ASC
        LIMIT 6
    ");
    $stmt->execute([$userType]);
    $featuredServices = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Get service packages
    $stmt = $pdo->prepare("
        SELECT * FROM service_packages 
        WHERE is_active = 1
        AND target_audience = ?
        ORDER BY sort_order ASC
    ");
    $stmt->execute([$userType]);
    $packages = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
} catch (Exception $e) {
    die('Database error: ' . $e->getMessage());
}

function formatPrice($price, $priceType) {
    $formatted = number_format($price, 2);
    switch ($priceType) {
        case 'per_kg':
            return $formatted . ' ₼/kq';
        case 'per_item':
            return $formatted . ' ₼/əşya';
        case 'per_month':
            return $formatted . ' ₼/ay';
        case 'percentage':
            return $formatted . '%';
        default:
            return $formatted . ' ₼';
    }
}
?>
<!DOCTYPE html>
<html lang="az">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Əlavə Xidmətlər - Global Express</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: linear-gradient(135deg, #f0fdf4 0%, #e0f2fe 50%, #f0fdf4 100%);
            min-height: 100vh;
        }
        
        .header {
            background: white;
            padding: 20px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }
        
        .header-content {
            max-width: 1400px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .logo {
            font-size: 28px;
            font-weight: 900;
            background: linear-gradient(135deg, #10b981 0%, #06b6d4 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .header-nav {
            display: flex;
            gap: 30px;
        }
        
        .header-nav a {
            color: #0f172a;
            text-decoration: none;
            font-weight: 600;
            transition: color 0.3s;
        }
        
        .header-nav a:hover {
            color: #10b981;
        }
        
        .container {
            max-width: 1400px;
            margin: 0 auto;
            padding: 40px 20px;
        }
        
        .page-title {
            text-align: center;
            margin-bottom: 50px;
        }
        
        .page-title h1 {
            font-size: 48px;
            font-weight: 900;
            background: linear-gradient(135deg, #10b981 0%, #06b6d4 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
            margin-bottom: 15px;
        }
        
        .page-title p {
            font-size: 20px;
            color: #64748b;
        }
        
        .tabs {
            display: flex;
            justify-content: center;
            gap: 20px;
            margin-bottom: 50px;
            flex-wrap: wrap;
        }
        
        .tab {
            padding: 15px 30px;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            background: white;
            cursor: pointer;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .tab:hover {
            border-color: #10b981;
            transform: translateY(-2px);
        }
        
        .tab.active {
            background: linear-gradient(135deg, #10b981 0%, #06b6d4 100%);
            color: white;
            border-color: transparent;
        }
        
        .tab-content {
            display: none;
        }
        
        .tab-content.active {
            display: block;
        }
        
        /* Featured Services */
        .featured-section {
            margin-bottom: 60px;
        }
        
        .section-title {
            font-size: 32px;
            font-weight: 800;
            color: #0f172a;
            margin-bottom: 30px;
            display: flex;
            align-items: center;
            gap: 15px;
        }
        
        .featured-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 25px;
            margin-bottom: 60px;
        }
        
        .service-card {
            background: white;
            border-radius: 20px;
            padding: 30px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
            transition: all 0.3s;
            border: 2px solid transparent;
            position: relative;
            overflow: hidden;
        }
        
        .service-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 30px rgba(16, 185, 129, 0.2);
            border-color: #10b981;
        }
        
        .service-card.featured::before {
            content: '⭐ Populyar';
            position: absolute;
            top: 15px;
            right: -35px;
            background: linear-gradient(135deg, #f59e0b 0%, #ef4444 100%);
            color: white;
            padding: 5px 40px;
            font-size: 12px;
            font-weight: 700;
            transform: rotate(45deg);
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
        }
        
        .service-icon {
            font-size: 48px;
            margin-bottom: 20px;
        }
        
        .service-name {
            font-size: 22px;
            font-weight: 700;
            color: #0f172a;
            margin-bottom: 10px;
        }
        
        .service-description {
            color: #64748b;
            margin-bottom: 20px;
            line-height: 1.6;
        }
        
        .service-price {
            font-size: 28px;
            font-weight: 900;
            color: #10b981;
            margin-bottom: 20px;
        }
        
        .service-button {
            width: 100%;
            padding: 14px;
            background: linear-gradient(135deg, #10b981 0%, #06b6d4 100%);
            color: white;
            border: none;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .service-button:hover {
            transform: scale(1.05);
            box-shadow: 0 6px 20px rgba(16, 185, 129, 0.4);
        }
        
        /* Category Sections */
        .category-section {
            margin-bottom: 60px;
        }
        
        .category-header {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-bottom: 30px;
            padding-bottom: 15px;
            border-bottom: 3px solid #10b981;
        }
        
        .category-icon {
            font-size: 40px;
        }
        
        .category-title {
            font-size: 28px;
            font-weight: 800;
            color: #0f172a;
        }
        
        .category-description {
            color: #64748b;
            font-size: 16px;
        }
        
        .services-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 20px;
        }
        
        /* Package Cards */
        .packages-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 30px;
        }
        
        .package-card {
            background: white;
            border-radius: 24px;
            padding: 40px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
            position: relative;
            border: 3px solid transparent;
            transition: all 0.3s;
        }
        
        .package-card.popular {
            border-color: #10b981;
            transform: scale(1.05);
        }
        
        .package-card.popular::before {
            content: '🔥 Ən Seçilən';
            position: absolute;
            top: -15px;
            left: 50%;
            transform: translateX(-50%);
            background: linear-gradient(135deg, #10b981 0%, #06b6d4 100%);
            color: white;
            padding: 8px 25px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 700;
            box-shadow: 0 4px 15px rgba(16, 185, 129, 0.3);
        }
        
        .package-name {
            font-size: 26px;
            font-weight: 800;
            color: #0f172a;
            margin-bottom: 10px;
        }
        
        .package-description {
            color: #64748b;
            margin-bottom: 25px;
        }
        
        .package-price {
            font-size: 36px;
            font-weight: 900;
            color: #10b981;
            margin-bottom: 10px;
        }
        
        .package-price-note {
            color: #64748b;
            font-size: 14px;
            margin-bottom: 25px;
        }
        
        .package-features {
            list-style: none;
            margin-bottom: 30px;
        }
        
        .package-features li {
            padding: 12px 0;
            color: #0f172a;
            display: flex;
            align-items: center;
            gap: 12px;
            border-bottom: 1px solid #f1f5f9;
        }
        
        .package-features li:before {
            content: "✓";
            color: #10b981;
            font-weight: 900;
            font-size: 20px;
        }
        
        .login-prompt {
            background: linear-gradient(135deg, #fef3c7 0%, #fde68a 100%);
            border: 2px solid #f59e0b;
            border-radius: 16px;
            padding: 30px;
            text-align: center;
            margin: 40px 0;
        }
        
        .login-prompt h3 {
            font-size: 24px;
            color: #92400e;
            margin-bottom: 15px;
        }
        
        .login-prompt p {
            color: #78350f;
            margin-bottom: 20px;
        }
        
        .login-prompt a {
            display: inline-block;
            padding: 15px 40px;
            background: #10b981;
            color: white;
            text-decoration: none;
            border-radius: 12px;
            font-weight: 700;
            transition: all 0.3s;
        }
        
        .login-prompt a:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(16, 185, 129, 0.3);
        }
        
        @media (max-width: 768px) {
            .featured-grid,
            .services-grid,
            .packages-grid {
                grid-template-columns: 1fr;
            }
            
            .page-title h1 {
                font-size: 32px;
            }
            
            .tabs {
                flex-direction: column;
            }
            
            .tab {
                width: 100%;
                text-align: center;
            }
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="header-content">
            <div class="logo">🌍 Global Express</div>
            <div class="header-nav">
                <a href="index.php">Ana səhifə</a>
                <?php if ($isLoggedIn): ?>
                    <a href="dashboard.php">Dashboard</a>
                    <a href="services.php">Xidmətlər</a>
                    <a href="logout.php">Çıxış</a>
                <?php else: ?>
                    <a href="login.php">Daxil ol</a>
                    <a href="register.php">Qeydiyyat</a>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <div class="container">
        <div class="page-title">
            <h1>Əlavə Xidmətlər</h1>
            <p>Göndərişlərinizi daha da yaxşılaşdırın</p>
        </div>
        
        <div class="tabs">
            <div class="tab active" onclick="showTab('featured')">⭐ Populyar Xidmətlər</div>
            <div class="tab" onclick="showTab('all')">📋 Bütün Xidmətlər</div>
            <div class="tab" onclick="showTab('packages')">📦 Paketlər</div>
        </div>
        
        <!-- Featured Services Tab -->
        <div id="featured" class="tab-content active">
            <?php if (!$isLoggedIn): ?>
                <div class="login-prompt">
                    <h3>🔐 Xidmətlərdən istifadə etmək üçün daxil olun</h3>
                    <p>Əlavə xidmətləri sifariş etmək üçün hesabınıza daxil olmağınız lazımdır</p>
                    <a href="login.php">Daxil ol</a>
                </div>
            <?php endif; ?>
            
            <div class="featured-section">
                <h2 class="section-title">⭐ Ən Çox İstifadə Edilən Xidmətlər</h2>
                <div class="featured-grid">
                    <?php foreach ($featuredServices as $service): ?>
                        <div class="service-card featured">
                            <div class="service-icon"><?php echo $service['icon']; ?></div>
                            <h3 class="service-name"><?php echo htmlspecialchars($service['name_az']); ?></h3>
                            <p class="service-description"><?php echo htmlspecialchars($service['description_az']); ?></p>
                            <div class="service-price"><?php echo formatPrice($service['price'], $service['price_type']); ?></div>
                            <?php if ($isLoggedIn): ?>
                                <button class="service-button" onclick="orderService(<?php echo $service['id']; ?>, '<?php echo htmlspecialchars($service['service_code']); ?>')">
                                    Sifariş et
                                </button>
                            <?php else: ?>
                                <button class="service-button" onclick="window.location.href='login.php'">
                                    Daxil olun
                                </button>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        
        <!-- All Services Tab -->
        <div id="all" class="tab-content">
            <?php foreach ($categories as $category): ?>
                <?php if (!empty($servicesByCategory[$category['id']])): ?>
                    <div class="category-section">
                        <div class="category-header">
                            <div class="category-icon"><?php echo $category['icon']; ?></div>
                            <div>
                                <h2 class="category-title"><?php echo htmlspecialchars($category['name_az']); ?></h2>
                                <p class="category-description"><?php echo htmlspecialchars($category['description_az']); ?></p>
                            </div>
                        </div>
                        
                        <div class="services-grid">
                            <?php foreach ($servicesByCategory[$category['id']] as $service): ?>
                                <div class="service-card">
                                    <div class="service-icon"><?php echo $service['icon']; ?></div>
                                    <h3 class="service-name"><?php echo htmlspecialchars($service['name_az']); ?></h3>
                                    <p class="service-description"><?php echo htmlspecialchars($service['description_az']); ?></p>
                                    <div class="service-price"><?php echo formatPrice($service['price'], $service['price_type']); ?></div>
                                    <?php if ($isLoggedIn): ?>
                                        <button class="service-button" onclick="orderService(<?php echo $service['id']; ?>, '<?php echo htmlspecialchars($service['service_code']); ?>')">
                                            Sifariş et
                                        </button>
                                    <?php else: ?>
                                        <button class="service-button" onclick="window.location.href='login.php'">
                                            Daxil olun
                                        </button>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
        
        <!-- Packages Tab -->
        <div id="packages" class="tab-content">
            <div class="featured-section">
                <h2 class="section-title">📦 Xidmət Paketləri</h2>
                <p style="text-align: center; color: #64748b; margin-bottom: 40px; font-size: 18px;">
                    Paketlərlə xidmətlərdən daha sərfəli istifadə edin
                </p>
                
                <div class="packages-grid">
                    <?php foreach ($packages as $package): ?>
                        <?php
                            $features = json_decode($package['features'], true);
                            $isPopular = $package['is_popular'] == 1;
                        ?>
                        <div class="package-card <?php echo $isPopular ? 'popular' : ''; ?>">
                            <h3 class="package-name"><?php echo htmlspecialchars($package['name_az']); ?></h3>
                            <p class="package-description"><?php echo htmlspecialchars($package['description_az']); ?></p>
                            <div class="package-price"><?php echo formatPrice($package['price'], $package['price_type']); ?></div>
                            <?php if ($package['discount_percentage'] > 0): ?>
                                <p class="package-price-note">💰 <?php echo $package['discount_percentage']; ?>% endirim</p>
                            <?php endif; ?>
                            
                            <ul class="package-features">
                                <?php foreach ($features as $feature): ?>
                                    <li><?php echo htmlspecialchars($feature); ?></li>
                                <?php endforeach; ?>
                            </ul>
                            
                            <?php if ($isLoggedIn): ?>
                                <button class="service-button" onclick="orderPackage(<?php echo $package['id']; ?>, '<?php echo htmlspecialchars($package['package_code']); ?>')">
                                    Paketi seç
                                </button>
                            <?php else: ?>
                                <button class="service-button" onclick="window.location.href='login.php'">
                                    Daxil olun
                                </button>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
    
    <script>
        function showTab(tabName) {
            // Hide all tab contents
            document.querySelectorAll('.tab-content').forEach(content => {
                content.classList.remove('active');
            });
            
            // Remove active class from all tabs
            document.querySelectorAll('.tab').forEach(tab => {
                tab.classList.remove('active');
            });
            
            // Show selected tab content
            document.getElementById(tabName).classList.add('active');
            
            // Add active class to clicked tab
            event.target.classList.add('active');
        }
        
        function orderService(serviceId, serviceCode) {
            // Redirect to service order page
            window.location.href = 'order-service.php?service_id=' + serviceId + '&code=' + serviceCode;
        }
        
        function orderPackage(packageId, packageCode) {
            // Redirect to package order page
            window.location.href = 'order-package.php?package_id=' + packageId + '&code=' + packageCode;
        }
    </script>
</body>
</html>
