-- GlobalExpress Services - Seed Data
-- Populate all services with pricing and details

USE globalexpress_db;

-- ============================================
-- INDIVIDUAL CUSTOMER SERVICES
-- ============================================

-- Category 1: Shopping Assistance
INSERT INTO services (category_id, service_code, name, name_az, description, description_az, price, price_type, target_audience, icon, is_featured, sort_order) VALUES
(1, 'SHOP_ASSIST', 'Personal Shopping Assistant', 'Şəxsi Alış-veriş Köməkçisi', 'We find and purchase items for you from any store', 'İstənilən mağazadan sizin üçün məhsul tapıb alırıq', 25.00, 'per_item', 'both', '🛒', 1, 1),
(1, 'PRICE_COMPARE', 'Price Comparison Service', 'Qiymət Müqayisə Xidməti', 'Compare prices across multiple stores to find best deals', 'Ən yaxşı təklifləri tapmaq üçün qiymətləri müqayisə edirik', 10.00, 'fixed', 'both', '💰', 0, 2),
(1, 'PRODUCT_AUTH', 'Product Authentication', 'Məhsul Yoxlanışı', 'Verify authenticity of luxury and branded items', 'Lüks və brendli məhsulların orijinallığını yoxlayırıq', 30.00, 'per_item', 'individual', '✓', 0, 3),
(1, 'SIZE_CONSULT', 'Size & Fit Consultation', 'Ölçü Məsləhəti', 'Help with clothing sizes across different countries', 'Müxtəlif ölkələrin ölçü sistemləri ilə kömək', 5.00, 'per_item', 'individual', '👔', 0, 4);

-- Category 2: Quality Control
INSERT INTO services (category_id, service_code, name, name_az, description, description_az, price, price_type, target_audience, icon, is_featured, sort_order) VALUES
(2, 'PHOTO_SERVICE', 'Pre-shipment Photo Service', 'Foto Xidməti', 'Take photos of your package before shipping (3 photos)', 'Göndərmədən əvvəl bağlamanızın şəkillərini çəkirik', 5.00, 'fixed', 'both', '📸', 1, 1),
(2, 'QUALITY_CHECK', 'Quality Inspection', 'Keyfiyyət Yoxlanışı', 'Inspect items for defects and damage', 'Məhsulları qüsur və zədələrə görə yoxlayırıq', 10.00, 'fixed', 'both', '🔍', 1, 2),
(2, 'WEIGHT_VERIFY', 'Weight Verification', 'Çəki Yoxlanışı', 'Verify actual weight matches listed weight', 'Faktiki çəkinin qeyd edilmiş çəkiyə uyğunluğunu yoxlayırıq', 3.00, 'fixed', 'both', '⚖️', 0, 3),
(2, 'BOX_CONDITION', 'Package Condition Report', 'Qablaşdırma Vəziyyət Hesabatı', 'Document box condition with detailed report', 'Qutu vəziyyətini ətraflı hesabatla sənədləşdiririk', 8.00, 'fixed', 'both', '📋', 0, 4),
(2, 'BRAND_VERIFY', 'Brand Verification', 'Brend Təsdiqi', 'Check authenticity seals and brand markers', 'Orijinallıq möhürlərini və brend işarələrini yoxlayırıq', 15.00, 'per_item', 'individual', '🏷️', 0, 5);

-- Category 3: Packaging Services  
INSERT INTO services (category_id, service_code, name, name_az, description, description_az, price, price_type, target_audience, icon, is_featured, sort_order) VALUES
(3, 'PREMIUM_PACK', 'Premium Packaging', 'Premium Qablaşdırma', 'Extra protection with bubble wrap and sturdy boxes', 'Hava qabarcıqlı və möhkəm qutularla əlavə qorunma', 15.00, 'fixed', 'both', '📦', 1, 1),
(3, 'GIFT_WRAP', 'Gift Wrapping Service', 'Hədiyyə Qablaşdırması', 'Professional gift wrapping with ribbon and card', 'Lent və kartla professional hədiyyə qablaşdırması', 10.00, 'per_item', 'individual', '🎁', 0, 2),
(3, 'CUSTOM_PACK', 'Custom Packaging', 'Xüsusi Qablaşdırma', 'Branded boxes for special occasions', 'Xüsusi hallara uyğun brendli qutular', 20.00, 'per_item', 'both', '🎨', 0, 3),
(3, 'ECO_PACK', 'Eco-Friendly Packaging', 'Ekoloji Qablaşdırma', 'Sustainable and recyclable packaging materials', 'Davamlı və təkrar emal edilə bilən materiallar', 12.00, 'fixed', 'both', '♻️', 0, 4),
(3, 'FRAGILE_PACK', 'Fragile Item Packaging', 'Kövrək Əşya Qablaşdırması', 'Special packaging for delicate items', 'Zərif əşyalar üçün xüsusi qablaşdırma', 18.00, 'fixed', 'both', '⚠️', 0, 5);

-- Category 4: Storage & Handling
INSERT INTO services (category_id, service_code, name, name_az, description, description_az, price, price_type, target_audience, icon, is_featured, sort_order) VALUES
(4, 'EXTEND_STORAGE', 'Extended Storage', 'Uzadılmış Saxlama', 'Store packages beyond free period', 'Pulsuz müddətdən sonra bağlamaları saxlayırıq', 5.00, 'per_month', 'both', '📦', 0, 1),
(4, 'CONSOLIDATION', 'Package Consolidation', 'Bağlama Birləşdirməsi', 'Combine multiple packages into one shipment', 'Bir neçə bağlamanı bir göndərişdə birləşdiririk', 0.00, 'fixed', 'both', '📦', 1, 2),
(4, 'REPACKAGING', 'Repackaging Service', 'Yenidən Qablaşdırma', 'Repack items to reduce size and weight', 'Ölçü və çəkini azaltmaq üçün yenidən qablaşdırırıq', 8.00, 'fixed', 'both', '📦', 0, 3),
(4, 'HOLD_RELEASE', 'Hold & Release', 'Saxla və Göndər', 'Hold packages until you request shipment', 'Siz tələb edənə qədər bağlamaları saxlayırıq', 2.00, 'per_month', 'both', '⏸️', 0, 4),
(4, 'BATTERY_REMOVAL', 'Battery Removal', 'Batareya Çıxarılması', 'Remove/separate batteries for air shipping', 'Hava daşınması üçün batareyaları çıxarırıq', 5.00, 'fixed', 'both', '🔋', 0, 5);

-- Category 5: Documentation
INSERT INTO services (category_id, service_code, name, name_az, description, description_az, price, price_type, target_audience, icon, is_featured, sort_order) VALUES
(5, 'INVOICE_EDIT', 'Invoice Adjustment', 'Faktura Düzəlişi', 'Adjust invoice for customs optimization (legal amounts only)', 'Gömrük optimallaşdırması üçün faktura düzəlişi', 10.00, 'fixed', 'both', '📄', 1, 1),
(5, 'GIFT_DECLARE', 'Gift Declaration', 'Hədiyyə Bəyannaməsi', 'Declare items as gift to reduce duties', 'Rüsumları azaltmaq üçün hədiyyə kimi bəyan etmə', 8.00, 'fixed', 'individual', '🎁', 0, 2),
(5, 'COO_CERT', 'Certificate of Origin', 'Mənşə Sertifikatı', 'Obtain certificate of origin for customs', 'Gömrük üçün mənşə sertifikatı əldə etmə', 25.00, 'fixed', 'both', '📜', 0, 3),
(5, 'INSURANCE_DOC', 'Insurance Documentation', 'Sığorta Sənədləri', 'Complete insurance paperwork and claims', 'Sığorta sənədləri və iddialar', 15.00, 'fixed', 'both', '🛡️', 0, 4);

-- Category 7: Delivery Services
INSERT INTO services (category_id, service_code, name, name_az, description, description_az, price, price_type, target_audience, icon, is_featured, sort_order) VALUES
(7, 'SAME_DAY', 'Same-Day Delivery (Baku)', 'Eyni gün çatdırılma (Bakı)', 'Deliver within Baku on the same day', 'Bakı daxilində eyni gün çatdırılma', 15.00, 'fixed', 'both', '⚡', 1, 1),
(7, 'SCHEDULED', 'Scheduled Delivery', 'Planlaşdırılmış Çatdırılma', 'Choose specific date and time for delivery', 'Çatdırılma üçün xüsusi tarix və vaxt seçin', 10.00, 'fixed', 'both', '📅', 0, 2),
(7, 'WEEKEND', 'Weekend Delivery', 'Həftə sonu Çatdırılması', 'Saturday and Sunday delivery available', 'Şənbə və Bazar günləri çatdırılma', 12.00, 'fixed', 'both', '📦', 0, 3),
(7, 'EVENING', 'Evening Delivery', 'Axşam Çatdırılması', 'Delivery after 6 PM', '18:00-dan sonra çatdırılma', 8.00, 'fixed', 'both', '🌙', 0, 4);

-- ============================================
-- BUSINESS SERVICES
-- ============================================

-- Category 6: Business Services
INSERT INTO services (category_id, service_code, name, name_az, description, description_az, price, price_type, target_audience, icon, is_featured, requires_approval, sort_order) VALUES
(6, 'INVENTORY_MGT', 'Inventory Management', 'İnventar İdarəetməsi', 'Store and manage your inventory in our warehouse', 'Anbarımızda inventarınızı saxlayın və idarə edin', 2.00, 'per_kg', 'business', '📊', 1, 1, 1),
(6, 'PICK_PACK', 'Pick & Pack Service', 'Seç və Qablaşdır', 'Package individual orders for your customers', 'Müştəriləriniz üçün fərdi sifarişləri qablaşdırırıq', 8.00, 'per_item', 'business', '📦', 1, 0, 2),
(6, 'DROPSHIP', 'Dropshipping Service', 'Dropshipping Xidməti', 'Ship directly to your end customers', 'Birbaşa son müştərilərinizə göndərim', 10.00, 'per_item', 'business', '🚚', 1, 0, 3),
(6, 'API_INTEGRATION', 'API Integration', 'API İnteqrasiyası', 'Connect your store to our system', 'Mağazanızı sistemimizə qoşun', 500.00, 'fixed', 'business', '🔌', 1, 1, 4),
(6, 'API_MONTHLY', 'API Monthly Fee', 'API Aylıq Ödəniş', 'Monthly API access and maintenance', 'Aylıq API əlçatanlığı və texniki dəstək', 100.00, 'per_month', 'business', '🔌', 0, 0, 5),
(6, 'CUSTOMS_BROKER', 'Customs Brokerage', 'Gömrük Brokeri', 'Full customs clearance and documentation', 'Tam gömrük rəsmiləşdirilməsi və sənədləşdirmə', 150.00, 'per_item', 'business', '🛃', 0, 1, 6),
(6, 'QUALITY_INSPECT', 'Pre-shipment Inspection', 'Göndərmə əvvəli Yoxlama', 'Inspect products at supplier before shipping', 'Göndərmədən əvvəl tədarükçüdə məhsul yoxlaması', 200.00, 'fixed', 'business', '✓', 0, 1, 7),
(6, 'SOURCING', 'Product Sourcing', 'Məhsul Təchizatı', 'Find and verify suppliers for your products', 'Məhsullarınız üçün tədarükçü tapıb yoxlayırıq', 0.00, 'percentage', 'business', '🔎', 0, 1, 8),
(6, 'LABELING', 'Product Labeling', 'Məhsul Etiketləməsi', 'Add Azerbaijan-required labels to products', 'Məhsullara Azərbaycan tələb olunan etiketlər əlavə etmə', 3.00, 'per_item', 'business', '🏷️', 0, 0, 9),
(6, 'WHITE_LABEL', 'White Label Service', 'Ağ Etiket Xidməti', 'Remove supplier branding and add yours', 'Tədarükçü brendini silir və sizinkini əlavə edirik', 15.00, 'per_item', 'business', '🎨', 0, 1, 10);

-- Category 8: Premium Services
INSERT INTO services (category_id, service_code, name, name_az, description, description_az, price, price_type, target_audience, icon, is_featured, requires_approval, sort_order) VALUES
(8, 'CONCIERGE', 'Concierge Service', 'Konsierj Xidməti', '24/7 priority support with dedicated manager', 'Xüsusi menecerlə 24/7 prioritet dəstək', 500.00, 'per_month', 'both', '🎩', 1, 1, 1),
(8, 'VIP_DELIVERY', 'VIP Hand Delivery', 'VIP Əl ilə Çatdırılma', 'Manager personally delivers to your location', 'Menecer şəxsən sizin ünvanınıza çatdırır', 50.00, 'fixed', 'both', '👤', 1, 0, 2),
(8, 'PRIORITY_PROC', 'Priority Processing', 'Prioritet Emal', 'Skip the queue - process first', 'Növbəni keçin - birinci emal olunur', 25.00, 'fixed', 'both', '⚡', 0, 0, 3),
(8, 'MARKET_RESEARCH', 'Market Research', 'Bazar Araşdırması', 'Research products and market trends', 'Məhsul və bazar tendensiyalarını araşdırırıq', 300.00, 'fixed', 'business', '📈', 0, 1, 4);

-- ============================================
-- SERVICE PACKAGES
-- ============================================

-- Individual Packages
INSERT INTO service_packages (package_code, name, name_az, description, description_az, target_audience, price, price_type, discount_percentage, is_popular, sort_order, features) VALUES
('EXPRESS_CARE', 'Express Care Package', 'Express Qayğı Paketi', 'Perfect for frequent shoppers who want premium service', 'Tez-tez alış-veriş edənlər üçün premium xidmət', 'individual', 50.00, 'per_shipment', 15, 1, 1,
'["3-day express shipping", "Pre-shipment photos (5)", "Premium packaging", "SMS + Email alerts", "Insurance up to $500", "Priority customer support"]'),

('SHOPPER_PRO', 'Shopper Pro Monthly', 'Alıcı Pro Aylıq', 'Monthly package for serious online shoppers', 'Ciddi onlayn alıcılar üçün aylıq paket', 'individual', 99.00, 'per_month', 20, 0, 2,
'["10 free photo services", "5 free quality checks", "2 free consolidations", "Extended storage (90 days)", "Priority processing", "15% discount on all services"]');

-- Business Packages  
INSERT INTO service_packages (package_code, name, name_az, description, description_az, target_audience, price, price_type, discount_percentage, is_popular, sort_order, features) VALUES
('BUSINESS_STARTER', 'Business Starter', 'Biznes Başlanğıc', 'Essential services for small e-commerce businesses', 'Kiçik e-ticarət biznesləri üçün əsas xidmətlər', 'business', 500.00, 'per_month', 25, 1, 3,
'["50 pick & pack orders", "Inventory storage (100 kg)", "Basic API access", "Monthly reports", "Email support", "10% discount on extra services"]'),

('BUSINESS_PRO', 'Business Pro', 'Biznes Pro', 'Complete solution for growing businesses', 'İnkişaf edən bizneslər üçün tam həll', 'business', 1500.00, 'per_month', 30, 1, 4,
'["200 pick & pack orders", "Inventory storage (500 kg)", "Full API integration", "Dropshipping support", "Priority customs clearance", "Dedicated account manager", "Weekly reports", "20% discount on extra services"]'),

('DROPSHIP_ELITE', 'Dropship Elite', 'Dropship Elit', 'Premium dropshipping and fulfillment', 'Premium dropshipping və yerinə yetirmə', 'business', 1000.00, 'per_month', 35, 0, 5,
'["Unlimited orders (5₼ each)", "Branded packaging", "Auto-tracking updates", "1-day processing", "Returns management", "API integration", "Priority support"]');

-- ============================================
-- Link services to packages
-- ============================================

-- Express Care Package
INSERT INTO package_services (package_id, service_id, quantity, is_unlimited) VALUES
(1, (SELECT id FROM services WHERE service_code = 'PHOTO_SERVICE'), 5, 0),
(1, (SELECT id FROM services WHERE service_code = 'PREMIUM_PACK'), 1, 0),
(1, (SELECT id FROM services WHERE service_code = 'QUALITY_CHECK'), 1, 0);

-- Shopper Pro Monthly
INSERT INTO package_services (package_id, service_id, quantity, is_unlimited) VALUES
(2, (SELECT id FROM services WHERE service_code = 'PHOTO_SERVICE'), 10, 0),
(2, (SELECT id FROM services WHERE service_code = 'QUALITY_CHECK'), 5, 0),
(2, (SELECT id FROM services WHERE service_code = 'CONSOLIDATION'), 2, 0),
(2, (SELECT id FROM services WHERE service_code = 'PRIORITY_PROC'), 0, 1);

-- Business Starter
INSERT INTO package_services (package_id, service_id, quantity, is_unlimited) VALUES
(3, (SELECT id FROM services WHERE service_code = 'PICK_PACK'), 50, 0),
(3, (SELECT id FROM services WHERE service_code = 'INVENTORY_MGT'), 100, 0);

-- Business Pro
INSERT INTO package_services (package_id, service_id, quantity, is_unlimited) VALUES
(4, (SELECT id FROM services WHERE service_code = 'PICK_PACK'), 200, 0),
(4, (SELECT id FROM services WHERE service_code = 'INVENTORY_MGT'), 500, 0),
(4, (SELECT id FROM services WHERE service_code = 'API_INTEGRATION'), 1, 0),
(4, (SELECT id FROM services WHERE service_code = 'API_MONTHLY'), 0, 1),
(4, (SELECT id FROM services WHERE service_code = 'DROPSHIP'), 0, 1);

-- Dropship Elite
INSERT INTO package_services (package_id, service_id, quantity, is_unlimited) VALUES
(5, (SELECT id FROM services WHERE service_code = 'DROPSHIP'), 0, 1),
(5, (SELECT id FROM services WHERE service_code = 'API_INTEGRATION'), 1, 0),
(5, (SELECT id FROM services WHERE service_code = 'API_MONTHLY'), 0, 1),
(5, (SELECT id FROM services WHERE service_code = 'PICK_PACK'), 0, 1);

-- ============================================
-- Sample Promotions
-- ============================================

INSERT INTO service_promotions (promo_code, name, description, discount_type, discount_value, applicable_to, min_purchase_amount, usage_limit, valid_from, valid_to, is_active) VALUES
('WELCOME10', 'Welcome Discount', 'Get 10% off your first service order', 'percentage', 10.00, 'all_services', 20.00, 1000, NOW(), DATE_ADD(NOW(), INTERVAL 6 MONTH), 1),
('PHOTO5FREE', '5 Free Photos', 'Get 5 free photo services', 'free_service', 0.00, 'specific_services', 0.00, 500, NOW(), DATE_ADD(NOW(), INTERVAL 3 MONTH), 1),
('BIZSTART', 'Business Start Bonus', '50₼ off Business Starter package', 'fixed_amount', 50.00, 'packages', 500.00, 100, NOW(), DATE_ADD(NOW(), INTERVAL 1 MONTH), 1);

-- ============================================
-- VERIFICATION & SUMMARY
-- ============================================

-- Count services by category
SELECT 
    sc.name_az as 'Kateqoriya',
    COUNT(s.id) as 'Xidmət Sayı',
    ROUND(AVG(s.price), 2) as 'Orta Qiymət',
    MIN(s.price) as 'Min Qiymət',
    MAX(s.price) as 'Max Qiymət'
FROM service_categories sc
LEFT JOIN services s ON sc.id = s.category_id
GROUP BY sc.id, sc.name_az
ORDER BY sc.sort_order;

-- Count packages
SELECT 
    'Total Packages' as 'Tip',
    COUNT(*) as 'Say'
FROM service_packages
UNION ALL
SELECT 
    target_audience,
    COUNT(*)
FROM service_packages
GROUP BY target_audience;

-- Service price ranges
SELECT 
    price_type as 'Qiymət Tipi',
    COUNT(*) as 'Xidmət Sayı',
    ROUND(AVG(price), 2) as 'Orta Qiymət'
FROM services
GROUP BY price_type;

SELECT '✅ All services have been created successfully!' as 'Status';
